<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/ecommerce/Spedizione.php";
    
    if(isset($_GET["id"])) {
        $spedizione = new Spedizione($geecomDb,filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $spedizione->caricaDatiDalDatabase();
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Componente e-commerce - Creazione metodo spedizione</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formProdotto" action="../../../controller/ecommerce/controllerSpedizioni.php" method="post">
                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($spedizione) ? "modifica" : "crea")); ?>">
                    <input type="text" class="d-none" name="id" value="<?php echo((isset($spedizione) ? $spedizione->getId() : "0")); ?>">
                    
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Spedizione creata
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==220) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Spedizione modificata
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" id="operazione" value="modifica">

                        <div class="col-12 ">
                            <div class="form-row mb-3">
                                <div class="col-md-7 d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="home.php">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">E-commerce</a></li>
                                            <li class="breadcrumb-item"><a href="index.php?status=250">Spedizioni</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($spedizione)? $spedizione->getNome() : "Nuovo metodo spedizione"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-md-5 text-right">
                                    <a class="btn btn-primary mr-1" href="creaSpedizione.php">Crea nuovo<i class="fas fa-plus ml-2"></i></a>
                                    <a class="btn btn-outline-primary" href="index.php?status=250"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>
                            
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" data-toggle="tab" href="#datiBase" role="tab" aria-controls="profile" aria-selected="false">Dati di base</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link " data-toggle="tab" href="#fasceDiPrezzo" role="tab" aria-controls="profile" aria-selected="false">Fasce di prezzo</a>
                                </li>
                            </ul>

                            <div class="tab-content" id="myTabContent">                                
                                <div class="tab-pane fade show active" id="datiBase" role="tabpanel" aria-labelledby="home-tab">
                                    <div class="row">
                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Nome</label>
                                            <input  type="text" class="form-control" name="nome" value="<?php echo((isset($spedizione)? $spedizione->getNome() : ""))?>" placeholder="Nome">
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label for="titolo-articolo" id="labelAlias">Descrizione</label>
                                            <input  type="text" class="form-control" name="descrizione" value="<?php echo((isset($spedizione)? $spedizione->getDescrizione() : ""))?>" placeholder="Descrizione">
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Disponibile</label>
                                            <input type="checkbox" class="js-switch" name="disponibile"  value="si" <?php echo((isset($spedizione) && $spedizione->getDisponibile()=="si") ? "checked":"") ?>>
                                        </div>

                                        <div class="w-100"></div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Costo base €</label>
                                            <input type="number" step="0.01" class="form-control" name="costo" value="<?php echo((isset($spedizione)? $spedizione->getCosto() : "0"))?>" placeholder="Link">
                                            <small class="text-muted"> La tariffa base per le spedizioni che verrà utilizzata se non sono state definite fasce di prezzo</small>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Costo base (zone disagiate) €</label>
                                            <input type="number" step="0.01" class="form-control" name="costoZoneDisagiate" value="<?php echo((isset($spedizione)? $spedizione->getCostoZoneDisagiate() : "0"))?>" placeholder="Link">
                                            <small class="text-muted"> La tariffa base per le spedizioni in zone disagiate che verrà utilizzata se non sono state definite fasce di prezzo</small>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Importo minimo carrello €</label>
                                            <input  type="number" step="0.01" class="form-control" name="importoMinimoCarrello" value="<?php echo((isset($spedizione)? $spedizione->getImportoMinimoCarrello() : "0"))?>" placeholder="Link">
                                            <small class="text-muted"> Questo metodo di spedizione sarà disponibile quando l'importo del carrello sarà uguale o superiore a quello indicato</small>
                                        </div>

                                        <div class="w-100"></div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Giorni necessari per la consegna</label>
                                            <input type="number" step="0.01" class="form-control" name="giorniNecessari" value="<?php echo((isset($spedizione)? $spedizione->getGiorniNecessari() : "0"))?>" placeholder="Link">
                                            <small class="text-muted"> Serve per calcolare la data di ricevimento della consegna</small>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="giorniInCuiSiSpedisce">Giorni in cui vengono effettuate le spedizioni</label>
                                            <?php
                                                $giorniInCuiSiSpedisce = array("Tutti i giorni","Lunedi - Sabato","Lunedi - Venerdi");
                                            ?>
                                            <select class="selectpicker w-100" id="giorniInCuiSiSpedisce" name="giorniInCuiSiSpedisce">
                                                    <?php
                                                        foreach($giorniInCuiSiSpedisce as $opzione) {
                                                            if($spedizione->getId()!=0 && $spedizione->getGiorniInCuiSiSpedisce() == $opzione) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"$opzione\" $selezionato >{$opzione}</option>";
                                                        }
                                                    ?>
                                            </select>
                                            <small class="text-muted"> I giorni di spedizione verranno conteggiati a partire dal primo giorno utile definito in questo campo</small>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="titolo-articolo" id="labelAlias">Orario limite per la spedizione</label>
                                            <input type="time" class="form-control" name="orarioLimite" value="<?= isset($spedizione)? $spedizione->getOrarioLimite() : "00:00:00" ?>">
                                            <small class="text-muted"> Superato questo orario verrà considerato valido per la spedizione il primo giorno utile successivo </small>
                                        </div>
                                        
                                        <div class="w-100"></div>

                                        <div class="form-group col-md-3">
                                            <label for="select1" class="sottotitolo-articolo">Categoria</label>
                                            <select class="selectpicker w-100" name="categoria">
                                                <option value="0">Tutte</option>
                                                <?php
                                                    $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre=0 ORDER BY posizione ASC";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($categoria = $risNomi->fetch_assoc()) {
                                                        if(isset($spedizione) && $spedizione->getId()!=0 && $spedizione->getCategoria() == $categoria["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";

                                                        $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                        $risSottoCategorie    = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                        while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                            if(isset($spedizione) && $spedizione->getId()!=0 && $spedizione->getCategoria() == $sottoCategoria["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }

                                                            echo"<option value=\"{$sottoCategoria["id"]}\" $selezionato > - {$sottoCategoria["nome"]}</option>";

                                                            $querySottoCategorie  = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                            $risSottoSottoCategorie    = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                            while($sottoSottoCategoria = $risSottoSottoCategorie->fetch_assoc()) {
                                                                if(isset($spedizione) && $spedizione->getId()!=0 && $spedizione->getCategoria() == $sottoSottoCategoria["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }

                                                                echo"<option value=\"{$sottoSottoCategoria["id"]}\" $selezionato > -- {$sottoSottoCategoria["nome"]}</option>";
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted"> Questo metodo di spedizione sarà disponibile quando l'importo del carrello sarà uguale o superiore a quello indicato</small>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="select1" class="sottotitolo-articolo">Area geografica</label>
                                            <select class="selectpicker w-100" name="areaGeografica">
                                                <option value="0">Tutte</option>
                                                <?php
                                                    $queryNomiTag = "SELECT * FROM geecEc_areeGeografiche";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($areaGeografica = $risNomi->fetch_assoc()) {
                                                        if(isset($spedizione) && $spedizione->getId()!=0 && $spedizione->getAreaGeografica() == $areaGeografica["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$areaGeografica["id"]}\" $selezionato >{$areaGeografica["nome"]}</option>";
                                                    }
                                                ?>
                                            </select>
                                            <small class="text-muted"> Se sono state definite aree geografiche questa spedizione verrà mostrata se l'indirizzo di spedizione si trova in una delle nazioni incluse nell'area geografica selezionata</small>
                                        </div>
                                    </div>

                                    <button type="button" class="btn btn-primary float-right mt-3" onclick="document.formProdotto.submit()"><i class="fas fa-check"></i> Salva</button>

                                </div>
                        </form>
                                <div class="tab-pane fade show" id="fasceDiPrezzo" role="tabpanel" aria-labelledby="home-tab">
                                    <div class="row">
                                        <div class="col-lg-4 col-xl-3">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <h5 class="mb-3"> Aggiungi fascia di prezzo </h5>
                                                    <div class="options-box">
                                                        <div class="form-group">
                                                            <label>Da (kg)</label>
                                                            <input type="number" class="form-control" id="pesoMinimo" placeholder="Peso minimo">
                                                        </div>

                                                        <div class="form-group">
                                                            <label>A (kg)</label>
                                                            <input type="number" class="form-control" id="pesoMassimo" placeholder="Peso massimo">
                                                        </div>

                                                        <div class="form-group">
                                                            <label>Costo €</label>
                                                            <input type="number" class="form-control" id="costo"  placeholder="Costo">
                                                        </div>

                                                        <div class="form-group">
                                                            <label>Costo zone disagiate €</label>
                                                            <input type="number" class="form-control" id="costoZoneDisagiate"  placeholder="Costo zone disagiate">
                                                        </div>

                                                        <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaFasciaDiPrezzo()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>

                                        <div class="col-lg-8 col-xl-9">
                                            <div id="divElencoElementi" class="row">
                                                <?php 
                                                    $spedizione->stampaFasceDiPrezzo();
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Colonna principale -->
                </div>

            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
            
            include "../include/modal/eliminaElemento.php";
        ?>
            <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'immagine?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                            </div>
                            <input type="text" class="d-none" id="idImmagineDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        
        <?php 
            if(isset($spedizione)) {
        ?>
        <div class="modal fade" id="modifica-fascia-prezzo" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica fascia di prezzo</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <input type="text" class="d-none" id="idVoceMenuDaModificare" name="id">
                            
                            <div class="form-group">
                                <label for="nome-voce-menu-1">Peso minimo (kg)</label>
                                <input type="number" class="form-control" id="pesoMinimoDaModificare" placeholder="Peso minimo">
                            </div>

                            <div class="form-group">
                                <label for="nome-voce-menu-1">Peso massimo (kg)</label>
                                <input type="number" class="form-control" id="pesoMassimoDaModificare" placeholder="Peso massimo">
                            </div>
                            
                            <div class="form-group">
                                <label for="nome-voce-menu-2">Costo €</label>
                                <input type="number" step="0.01" class="form-control" id="costoFasciaDaModificare" name="icona" placeholder="Costo">
                            </div>

                            <div class="form-group" id="divLinkMenuDaModificare">
                                <label for="nome-voce-menu-3">Costo zone disagiate €</label>
                                <input type="number" step="0.01" class="form-control" id="costoFasciaZoneDisagiateDaModificare" placeholder="Costo zone disagiate">
                            </div>
                      </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaFasciaDiPrezzo()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>    
        <?php
            }
            include "../include/jsBaseComponenti.php";
        ?>
        
        <script>
            function creaFasciaDiPrezzo() {
                var prezzoMinimo       = $('#pesoMinimo').val();
                var prezzoMassimo      = $('#pesoMassimo').val();
                var costo              = $('#costo').val();
                var costoZoneDisagiate = $('#costoZoneDisagiate').val();
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerSpedizioni.php",
                    data:{
                        operazione:"aggiungiFasciaDiPrezzo",
                        id:<?php echo $spedizione->getId() ?>,
                        pesoMinimo:prezzoMinimo,
                        pesoMassimo:prezzoMassimo,
                        costo:costo,
                        costoZoneDisagiate:costoZoneDisagiate
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function modificaFasciaDiPrezzo(id,pesoMinimo,pesoMassimo,costo,costoZoneDisagiate) {
                $('#idVoceMenuDaModificare').val(id);
                $('#pesoMinimoDaModificare').val(pesoMinimo);
                $('#pesoMassimoDaModificare').val(pesoMassimo);
                $('#costoFasciaDaModificare').val(costo);
                $('#costoFasciaZoneDisagiateDaModificare').val(costoZoneDisagiate);
                $('#modifica-fascia-prezzo').modal('show');
            }
       
            function eseguiModificaFasciaDiPrezzo() {
                var id          = $('#idVoceMenuDaModificare').val();
                var pesoMinimo  = $('#pesoMinimoDaModificare').val();
                var pesoMassimo = $('#pesoMassimoDaModificare').val();
                var costo       = $('#costoFasciaDaModificare').val();
                var costoZoneDisagiate = $('#costoFasciaZoneDisagiateDaModificare').val();
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerSpedizioni.php",
                    data:{
                        operazione:"modificaFasciaDiPrezzo",
                        id:<?php echo $spedizione->getId() ?>,
                        idFascia:id,
                        pesoMinimo:pesoMinimo,
                        pesoMassimo:pesoMassimo,
                        costo:costo,
                        costoZoneDisagiate:costoZoneDisagiate
                    },
                    success:function(result) {
                        if(result=="ok") {
                            aggiornaDivElementi();
                            $('#modifica-fascia-prezzo').modal('hide');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerSpedizioni.php",
                    data:{
                        operazione:"stampaFasceDiPrezzo",
                        id:<?php echo $spedizione->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert(xhr.status+" "+thrownError);
                    }
                });
            }
            
            function eliminaElemento(id,nomeElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../../../controller/ecommerce/controllerSpedizioni.php",
                    data:{
                        operazione:"eliminaFasciaDiPrezzo",
                        id:<?php echo $spedizione->getId() ?>,
                        idFascia:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("fasciaDiPrezzo"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>